﻿uses MathExtensions;


// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin    
   var one := 10;
   while True do begin   
      for var two := 100 to 1000 do begin
          // условия задачи:
           var uslovie1 := one + 100 = 2 * (two - 100);
           var uslovie2 := two + 10 = 6 * (one - 10);
           // печатаем ответ:
           if (uslovie1 and uslovie2) then begin
               Writeln($' У первого было:  {one} рупий');
               Writeln($' У второго было: {two} рупий');          
               Writeln;
               exit;
           end;
      end;
      one += 1;
   end;              
end;


procedure Solve2();
begin 
   var x := Range(0, 1000);
   var y := Range(0, 1000);   
   var res := Cartesian(x,y)
             .where(\(x, y) -> x + 100 = 2 * (y - 100))   // условие 1
             .where(\(x, y) -> y + 10  = 6 * (x - 10))   // условие 2
             .Select(\(x, y) -> (x, y));
   // печатаем ответ:
   foreach var (one, two) in res do begin
      Writeln($' У первого было:  {one} рупий');
      Writeln($' У второго было: {two} рупий');      
   end; 
   Writeln;    
end;
     

// Функция для решения системы линейных уравнений методом Крамера
function SolveLinearSystem(a1, b1, c1,
                           a2, b2, c2 : double) : (double, double);
begin
   // вычисляем определитель системы:
   var determinant := a1 * b2 - a2 * b1;

    // если определитель равен нулю,
    // система не имеет единственного решения:
    if (determinant = 0) then begin      
        Writeln($' Система не имеет единственного решения!');
        Writeln;  
        Result := (-1, -1);
    end;

   // вычисляем определители для x и y:
   var detX := c1 * b2 - c2 * b1;
   var detY := a1 * c2 - a2 * c1;

   // находим решения:
   var x := detX / determinant;
   var y := detY / determinant;
   Result := (x, y);
end;


procedure Solve3();
begin 
   // решаем систему уравнений:
   // уравнение 1: A - 2B = -300
   // уравнение 2:-6A + B = -70
   var res := SolveLinearSystem(1,  -2, -300,
                                -6,  1, -70);
   // печатаем ответ:
   Writeln($' У первого было:  {res.Item1} рупий');
   Writeln($' У второго было: {res.Item2} рупий');
   Writeln;    
end;

            
begin
   Writeln(' Индийские рупии');
   Writeln(' Математический фольклор. Задача Д11');   
   Writeln;  
   Solve();
   Solve2();   
   Solve3();       
end.
